/*
 * Decompiled with CFR 0.152.
 */
package com.mialerts.server;

import com.mialerts.server.Constants;
import com.mialerts.server.Snapshot;
import com.mialerts.server.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class MiAlertsDevice {
    String deviceID;
    Snapshot[] cameras;
    String deviceFolder;
    BufferedImage OSCQuad = null;

    MiAlertsDevice(String id) {
        this.deviceID = id.trim();
        if (this.deviceID == null || this.deviceID.length() == 0) {
            return;
        }
        this.deviceFolder = String.valueOf(Constants.ftp_folder) + File.separator + this.deviceID + File.separator;
        File dir = new File(this.deviceFolder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        dir.deleteOnExit();
        this.cameras = new Snapshot[4];
        this.cameras[0] = new Snapshot(String.valueOf(this.deviceFolder) + "camera1.jpeg");
        this.cameras[1] = new Snapshot(String.valueOf(this.deviceFolder) + "camera2.jpeg");
        this.cameras[2] = new Snapshot(String.valueOf(this.deviceFolder) + "camera3.jpeg");
        this.cameras[3] = new Snapshot(String.valueOf(this.deviceFolder) + "camera4.jpeg");
    }

    public void setCameraImage(int idx, byte[] imageBuffer) {
        if (idx < 0 || idx > 4 || imageBuffer == null || imageBuffer.length < 10) {
            return;
        }
        this.cameras[idx].setImage(imageBuffer);
    }

    public boolean isSameID(String id) {
        if (id == null || this.deviceID == null) {
            return false;
        }
        if (id.length() == 0 || this.deviceID.length() == 0) {
            return false;
        }
        return id.trim().compareToIgnoreCase(this.deviceID) == 0;
    }

    public void saveQuadImage() {
        if (!Constants.save2x2Image) {
            return;
        }
        long starttime = System.currentTimeMillis();
        if (this.OSCQuad == null) {
            this.OSCQuad = new BufferedImage(Constants.nWidth * 2, Constants.nHeight * 2, 1);
        }
        Graphics2D osg = this.OSCQuad.createGraphics();
        osg.setColor(Constants.fillColor);
        osg.fillRect(0, 0, Constants.nWidth * 2, Constants.nHeight * 2);
        osg.setColor(Color.black);
        if (this.cameras[0].isValid()) {
            osg.drawImage((Image)this.cameras[0].getImage(), Constants.nWidth * 0, Constants.nHeight * 0, null);
        }
        if (this.cameras[1].isValid()) {
            osg.drawImage((Image)this.cameras[1].getImage(), Constants.nWidth * 1, Constants.nHeight * 0, null);
        }
        if (this.cameras[2].isValid()) {
            osg.drawImage((Image)this.cameras[2].getImage(), Constants.nWidth * 0, Constants.nHeight * 1, null);
        }
        if (this.cameras[3].isValid()) {
            osg.drawImage((Image)this.cameras[3].getImage(), Constants.nWidth * 1, Constants.nHeight * 1, null);
        }
        osg.drawLine(0, Constants.nHeight, Constants.nWidth * 2, Constants.nHeight);
        osg.drawLine(Constants.nWidth, 0, Constants.nWidth, Constants.nHeight * 2);
        try {
            File file = new File(String.valueOf(this.deviceFolder) + "camera_quad.jpeg");
            boolean hasFormat = ImageIO.write((RenderedImage)this.OSCQuad, "jpg", file);
            Utils.log("Quad File saved: " + hasFormat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        osg.dispose();
        long time = System.currentTimeMillis() - starttime;
        Utils.log("Saving 2x2 image took: " + time + " ms");
    }

    public boolean updateSnapshots() {
        boolean bInvalidated = false;
        int t = 0;
        while (t < 4) {
            this.cameras[t].updateImageFromFile();
            if (this.cameras[t].bNewImage) {
                bInvalidated = true;
            }
            ++t;
        }
        return bInvalidated;
    }

    public int getCameraImageSize(int i) {
        if (this.cameras != null && this.cameras[i] != null && this.cameras[i].imageBuffer != null) {
            return this.cameras[i].imageBuffer.length;
        }
        return 0;
    }

    public void setCameraImageUsed(int i) {
        if (this.cameras != null && this.cameras[i] != null) {
            this.cameras[i].bNewImage = false;
        }
    }

    public boolean isCameraImageNew(int i) {
        if (this.cameras != null && this.cameras[i] != null) {
            return this.cameras[i].bNewImage;
        }
        return true;
    }
}

