//
//  SideMenuViewController.m
//  MFSideMenuDemo
//
#import "SideMenuViewController.h"
#import "MFSideMenu.h"
#import "ViewController.h"
#import "DevicesListViewController.h"
@implementation SideMenuViewController
#pragma mark - View Rotate Methods

- (BOOL)shouldAutorotate
{
    return YES;
}

- (NSUInteger)supportedInterfaceOrientations
{
    return (UIInterfaceOrientationMaskAll);
}

-(BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation
{
    return UIInterfaceOrientationPortrait | UIInterfaceOrientationMaskLandscapeLeft | UIInterfaceOrientationMaskLandscapeRight;
}

-(void)viewDidLoad
{
    controllers = [[NSMutableArray alloc]init];
    titles = [[NSMutableArray alloc]init];
    [titles addObject:@"List of Devices"];
    [titles addObject:@"Alerts"];
    [titles addObject:@"Settings"];
    [titles addObject:@"Record"];
    [titles addObject:@"Videos Mux"];               
    
    
    self.dListCntrlr = [[DevicesListViewController alloc]initWithNibName:@"DevicesListViewController" bundle:nil];
    
    [controllers addObject:self.dListCntrlr];
    [controllers addObject:self.dListCntrlr];
    [controllers addObject:self.dListCntrlr];
    UIImageView *sbg = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"slide_bg"]];
    [sbg setFrame:CGRectMake(0, 0, 161.5, 480)];
    [self.tableView setBackgroundView:sbg];
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    isAppStart = TRUE;
    
    [super viewDidLoad];
}
-(void)viewWillAppear:(BOOL)animated
{[self.tableView reloadData];
    if (isAppStart==TRUE)
    {
        [self.tableView selectRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] animated:NO scrollPosition:0];

    }

}
#pragma mark - UITableViewDataSource


-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 50;
}
-(UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *hdView = [[UIView alloc]initWithFrame:CGRectMake(0,0,self.tableView.frame.size.width,50)];
    UIImageView *logo = [[UIImageView alloc]initWithFrame:CGRectMake(5,3, 44, 44)];
    [logo setImage: [UIImage imageNamed:@"logo_title.png"]];
    [hdView addSubview:logo];
    [logo release];
    UILabel *apptitle = [[UILabel alloc]initWithFrame:CGRectMake(60, 4, self.tableView.frame.size.width-60, 44)];
    [apptitle setText:@"auto i"];
    [apptitle setBackgroundColor:[UIColor clearColor]];
    [apptitle setTextColor:[UIColor whiteColor]];
    [apptitle setFont:[UIFont boldSystemFontOfSize:18]];
    [hdView setBackgroundColor:[UIColor blackColor]];
    //[hdView setBackgroundColor:[UIColor colorWithRed:50.0/255.0 green:59.0/255.0 blue:74.0/255.0 alpha:1]];

    [hdView addSubview:apptitle];
    [apptitle release];
    return hdView;
    
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [controllers count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        UIImage *img = [UIImage imageNamed:@"chevron.png" ];
        UIImageView *disclosure = [[UIImageView alloc]initWithImage:img highlightedImage:[UIImage imageNamed:@"chevron-active.png" ]];
        [disclosure setTag:1001];
        [disclosure setFrame:CGRectMake(250, 16, img.size.width, img.size.height)];
        [cell.contentView addSubview:disclosure];
        
    }
    cell.accessoryType = UITableViewCellAccessoryNone;
    cell.textLabel.text = [titles objectAtIndex: indexPath.row];
    cell.backgroundColor = [UIColor clearColor];
    cell.contentView.backgroundColor = [UIColor clearColor];
    cell.selectionStyle = UITableViewCellSelectionStyleGray;
    cell.textLabel.textColor = [UIColor whiteColor];
    cell.textLabel.highlightedTextColor = [UIColor blackColor];

    cell.textLabel.backgroundColor = [UIColor clearColor];
    [cell.textLabel setFont:[UIFont fontWithName:@"Helvetica" size:17]];
    
    UIImageView *bg = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"sidebarcell"]];
    [bg setFrame:CGRectMake(0, 0, 161.5,51)];
    // Configure the cell...
    cell.backgroundView = bg;
    return cell;
}


#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {

      if (isAppStart==TRUE) {
          isAppStart = FALSE;
         // return;
      }
    
    NSArray *clkdcontrollrs = [NSArray arrayWithObject:[controllers objectAtIndex:indexPath.row]];
    [MFSideMenuManager sharedManager].navigationController.viewControllers = clkdcontrollrs;
    [MFSideMenuManager sharedManager].navigationController.menuState = MFSideMenuStateHidden;
}

-(void)dealloc
{
    [controllers release];
    [titles release];
    [super dealloc];
}

@end
