//
//  iMapViewController.h
//  iDing
//
//  Created by Macbook Pro on 29/01/13.
//  Copyright (c) 2013 Abusamy Ltd.. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <MapKit/MapKit.h>
#import "iDeviceAdressAnnotation.h"
#import "Device.h"
#import "XMLParser.h"
#import "NVPolylineAnnotation.h"
#import "MapViewAnnotation.h"
#import "NVPolylineAnnotationView.h"
#import "RegexKitLite.h"
#import "AppDelegate.h"
@interface iMapViewController : UIViewController<MKMapViewDelegate,CLLocationManagerDelegate>
{
    IBOutlet MKMapView *devicesMapview;
    UIBarButtonItem *refreshBBtn;
    UIBarButtonItem *routeBBtn;

    Device *selectedDevice;
    iDeviceAdressAnnotation *addAnnotation;
    iDeviceAdressAnnotation *userLocationAnnotation;
    MKPinAnnotationView *annView;
    NSURLConnection *urlConnection;
    NSMutableData *mutableData;
    NVPolylineAnnotation *routePolyLine;
    NVPolylineAnnotation *polyLineannotation;
    NSTimer *autoUpdateTimer;
    
    
    
}

@property(nonatomic)CLLocationManager *locationManager;
//@property(nonatomic)NSTimer *timer;

@property(nonatomic,retain) Device *selectedDevice;
@property(nonatomic,retain) NSMutableData *mutableData;
@property(nonatomic,retain) NSURLConnection *urlConnection;
@property(nonatomic,retain) UIBarButtonItem *refreshBBtn;
@property(nonatomic,retain) IBOutlet MKMapView *devicesMapview;
@property(nonatomic,retain) iDeviceAdressAnnotation *addAnnotation;
@property(nonatomic,retain) iDeviceAdressAnnotation *userLocationAnnotation;
@property(nonatomic,retain) NSTimer *autoUpdateTimer;

-(void)refreshDevicesMap;
@end
