//
//  AlertDetailsViewController.m
//  iDing
//
//  Created by Macbook Pro on 30/01/13.
//  Copyright (c) 2013 Abusamy Ltd.. All rights reserved.
//

#import "AlertDetailsViewController.h"

@interface AlertDetailsViewController ()

@end

@implementation AlertDetailsViewController
@synthesize alrtDetailsTBVw,choosedAlert;
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.title = @"Alert Info";
    self.alrtDetailsTBVw .backgroundColor = [UIColor clearColor];
    self.alrtDetailsTBVw .backgroundView = nil;

    [self.alrtDetailsTBVw setDelegate:self];
    [self.alrtDetailsTBVw setDataSource:self];
    [self.alrtDetailsTBVw reloadData];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}




-(void)callWSForAlertsUpdate
{
    
}

#pragma mark -
#pragma mark Table View datasource methods

// Required Methods

// Return the number of rows in a section
-(NSInteger) tableView:(UITableView *)table numberOfRowsInSection:(NSInteger)section
{
	return 1;
}

// Returns cell to render for each row
-(UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
	static NSString *CellIdentifier = @"CellIdentifier";
	
	UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
	
	if (cell == nil) {
		cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
        
        int lablWidth = 200;
       
        UIButton *mapBtn = [UIButton buttonWithType:UIButtonTypeRoundedRect];
        [mapBtn setFrame:CGRectMake(15, 45, 50, 50)];
        [mapBtn setTitle:@"Map" forState:UIControlStateNormal];
        [mapBtn addTarget:self action:@selector(showAlertMap) forControlEvents:UIControlEventTouchUpInside];
        [cell.contentView addSubview:mapBtn];
        
        UILabel *iTitle = [[UILabel alloc]initWithFrame:CGRectMake(mapBtn.frame.size.width+mapBtn.frame.origin.x+15, 10, lablWidth, 30)];
        [iTitle setTag:4001];
        [iTitle setBackgroundColor:[UIColor clearColor]];
        [iTitle setTextColor:[UIColor blackColor]];
        [iTitle setFont:[UIFont boldSystemFontOfSize:17]];
        [cell.contentView addSubview:iTitle];
        
        UILabel *iTimeStamp = [[UILabel alloc]initWithFrame:CGRectMake(iTitle.frame.origin.x, iTitle.frame.origin.y+iTitle.frame.size.height, lablWidth, 30)];
        [iTimeStamp setTag:4002];
        [iTimeStamp setBackgroundColor:[UIColor clearColor]];
        [iTimeStamp setTextColor:[UIColor blackColor]];
        [cell.contentView addSubview:iTimeStamp];
        
        UILabel *iAlertTypeT = [[UILabel alloc]initWithFrame:CGRectMake(iTitle.frame.origin.x, iTimeStamp.frame.origin.y+iTimeStamp.frame.size.height, lablWidth, 30)];
        [iAlertTypeT setTag:4004];
        [iAlertTypeT setBackgroundColor:[UIColor clearColor]];
        [iAlertTypeT setTextColor:[UIColor blackColor]];
        [cell.contentView addSubview:iAlertTypeT];
     
        UILabel *iType = [[UILabel alloc]initWithFrame:CGRectMake(iTitle.frame.origin.x,iAlertTypeT.frame.origin.y+iAlertTypeT.frame.size.height, lablWidth, 30)];
        [iType setTag:4003];
        [iType setBackgroundColor:[UIColor clearColor]];
        [iType setTextColor:[UIColor blackColor]];
        [cell.contentView addSubview:iType];
        
        UILabel *iImpact = [[UILabel alloc]initWithFrame:CGRectMake(iTitle.frame.origin.x,iType.frame.origin.y+iType.frame.size.height, lablWidth, 30)];
        [iImpact setTag:4005];
        [iImpact setBackgroundColor:[UIColor clearColor]];
        [iImpact setTextColor:[UIColor blackColor]];
        [cell.contentView addSubview:iImpact];


        [iTitle         release];
        [iTimeStamp     release];
        [iAlertTypeT    release];
        [iType          release];
        [iImpact        release];

        
	}
	
	// Configure cell
	//alert_types_id,device_title,update_timestamp
	// Sets the text for the cell
    Alert *d = self.choosedAlert;
    UILabel *leftIdLBL          = (UILabel *)[cell viewWithTag:4000];
    UILabel *topTitleLBL        = (UILabel *)[cell viewWithTag:4001];
    UILabel *btmTimeStampLBL    = (UILabel *)[cell viewWithTag:4002];
    UILabel *btmType            = (UILabel *)[cell viewWithTag:4003];
    UILabel *btmalertT          = (UILabel *)[cell viewWithTag:4004];
    UILabel *btImpactLbl          = (UILabel *)[cell viewWithTag:4005];

    [leftIdLBL          setText:d.alertTypesId];
	[topTitleLBL        setText:d.deviceTitle];
    [btmTimeStampLBL    setText:d.updateTimeStamp];
    [btmType            setText:[NSString stringWithFormat:@"Type : %@",d.deviceType]];
    [btmalertT          setText:[NSString stringWithFormat:@"Alert Type : %@",d.alertTypesTitle]];
    [btImpactLbl        setText:[NSString stringWithFormat:@"Impact Level : %@",d.impactLevel]];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [cell setBackgroundColor:[UIColor blackColor]];
    [[cell textLabel] setTextColor:[UIColor greenColor]];
    [[cell textLabel] setBackgroundColor:[UIColor blackColor]];
    
    
    [[cell detailTextLabel] setBackgroundColor:[UIColor blackColor]];
    [[cell detailTextLabel] setTextColor:[UIColor greenColor]];
    
    [leftIdLBL setBackgroundColor:[UIColor blackColor]];
    [leftIdLBL setTextColor:[UIColor greenColor]];
    
     
    [topTitleLBL setBackgroundColor:[UIColor blackColor]];
    [topTitleLBL setTextColor:[UIColor greenColor]];
    [btmTimeStampLBL  setBackgroundColor:[UIColor blackColor]];
    [btmTimeStampLBL setTextColor:[UIColor greenColor]];

	return cell;
}


// Returns the number of section in a table view
-(NSInteger) numberOfSectionsInTableView:(UITableView *)tableView
{
	return 1;
}

#pragma mark -
#pragma mark Table View delegate methods

// Return the height for each cell
-(CGFloat) tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
	return 170;
}


-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
       
    
}

-(void)showAlertMap
{
    Alert *selectedD = self.choosedAlert;
    AlertMapViewController *iMap = [[AlertMapViewController alloc]initWithNibName:@"AlertMapViewController" bundle:nil];
    iMap.choosedAlert = selectedD;
    [self.navigationController pushViewController:iMap animated:YES];
}

- (void)dealloc {
    [alrtDetailsTBVw release];
    [super dealloc];
}
@end
