//
//  AlertMapViewController.m
//  iDing
//
//  Created by Macbook Pro on 30/01/13.
//  Copyright (c) 2013 Abusamy Ltd.. All rights reserved.
//

#import "AlertMapViewController.h"

@interface AlertMapViewController ()

@end

@implementation AlertMapViewController
@synthesize alertMapView,choosedAlert;
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    [self refreshDevicesMap];
    
    [alertMapView setDelegate:self];
    [alertMapView setShowsUserLocation:YES];
    self.title = self.choosedAlert.deviceTitle;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    [alertMapView release];
    [super dealloc];
}
-(void)refreshDevicesMap
{
    // -------------------Load Device on Current MapView
    MKCoordinateRegion region;
    MKCoordinateSpan span;
    span.latitudeDelta=0.2;
    span.longitudeDelta=0.2;
    
    CLLocationCoordinate2D location = [self addressLocation];
    region.span=span;
    region.center=location;
    if(addAnnotation != nil) {
        [alertMapView removeAnnotation:addAnnotation];
        addAnnotation = nil;
    }
    
    addAnnotation = [[iDeviceAdressAnnotation alloc] initWithCoordinate:location];
    
    addAnnotation.mTitle    = self.choosedAlert.deviceTitle;
    addAnnotation.mSubTitle = self.choosedAlert.deviceId;
    [alertMapView addAnnotation:addAnnotation];
    [alertMapView selectAnnotation:addAnnotation animated:FALSE];
    [[alertMapView viewForAnnotation:addAnnotation] setSelected:YES animated:NO];
    
    
    [alertMapView setRegion:region animated:TRUE];
    [alertMapView regionThatFits:region];
    // -----------------------------------------------------
    
}
-(CLLocationCoordinate2D) addressLocation {
    
    double latitude = [self.choosedAlert.latt doubleValue];
    double longitude = [self.choosedAlert.longg doubleValue];
    CLLocationCoordinate2D location;
    location.latitude = latitude;
    location.longitude = longitude;
    return location;
}

- (MKAnnotationView *) mapView:(MKMapView *)mapVw viewForAnnotation:(id <MKAnnotation>) annotation{
    
    if ([annotation isKindOfClass:[MKUserLocation class]])
        return nil;
    
    annView = (MKPinAnnotationView*)[mapVw dequeueReusableAnnotationViewWithIdentifier:@"currentloc"];
    if (annView == nil) {
        annView=[[MKPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:@"currentloc"];
        
        // UIImage *mapImage       = [UIImage imageNamed:@"downMark.png"];
        // annView.image           = mapImage;
        annView.pinColor = MKPinAnnotationColorGreen;
        annView.canShowCallout  = YES;
        [annView setSelected:YES animated:YES];
        annView.calloutOffset   = CGPointMake(-5, 5);
    }
    else
    {
        
        annView.annotation = annotation;
        [annView setSelected:YES animated:YES];
    }
    return annView;
    [annView release];
}



@end
