/*
 * Decompiled with CFR 0.152.
 */
package com.mialerts.server;

import com.mialerts.server.Constants;
import com.mialerts.server.Handler;
import com.mialerts.server.HandlerThread;
import com.mialerts.server.Utils;
import com.mialerts.server.Utils2;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class SocketServer
extends Thread {
    int nIndex = 0;
    Socket clientSocket = null;
    ServerSocket serverSocket = null;
    public static HandlerThread[] t = null;
    public static boolean bStop = false;
    int nPort = 8088;
    static long nextTimeToPrintReport = System.currentTimeMillis();
    static Runtime runtime = Runtime.getRuntime();

    public SocketServer(int port, int index) {
        this.nPort = port;
        this.nIndex = index;
    }

    public static void main(String[] args) {
        SocketServer server1;
        System.out.println("Initizing memory..");
        t = new HandlerThread[1500];
        System.out.println("Initizing memory tables..");
        Constants.processParams(args);
        Handler handlerObj = new Handler();
        handlerObj.initInternalImages();
        System.out.println("Launching servers..");
        int index = 0;
        ArrayList<SocketServer> servers = new ArrayList<SocketServer>();
        int port2 = Utils2.startSocket;
        while (port2 <= Utils2.endSocket) {
            System.out.println("Starting server on port " + port2);
            server1 = new SocketServer(port2, ++index);
            server1.start();
            servers.add(server1);
            ++port2;
        }
        System.out.println("All servers are up..");
        while (!bStop) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException port2) {
                // empty catch block
            }
        }
        int t = 0;
        while (t < servers.size()) {
            server1 = (SocketServer)servers.get(t);
            System.out.println("Stopping server#" + t + " on port " + server1.nPort);
            bStop = true;
            server1.stop();
            ++t;
        }
    }

    @Override
    public void run() {
        HandlerThread temp;
        int port_number = this.nPort;
        System.out.println("Initizing server at port: " + port_number);
        try {
            this.log("Initizing server memory.");
            this.serverSocket = new ServerSocket(port_number, 1500);
            this.log("success!");
        }
        catch (IOException e) {
            System.out.println(e);
            this.ex("Initizing server memory..", e);
            return;
        }
        System.out.println(SocketServer.getMemoryStatisics());
        if (this.serverSocket != null) {
            while (!bStop) {
                try {
                    this.log("Waiting for connection..");
                    this.clientSocket = this.serverSocket.accept();
                    if (this.clientSocket == null) {
                        Utils2.err("null connection..");
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.log("connection received, creating handlerObj..");
                    int i = 0;
                    while (i < 1500) {
                        if (t[i] != null && t[i].IsHanged(true)) {
                            this.log("Force closing handler slot: " + i + ", " + SocketServer.getMemoryStatisics());
                            temp = t[i];
                            SocketServer.t[i] = null;
                            if (temp != null) {
                                temp.end();
                            }
                        }
                        ++i;
                    }
                    boolean bProcessed = false;
                    if (!bStop) {
                        int i2 = 0;
                        while (i2 < 1500) {
                            if (t[i2] == null) {
                                this.log("connection handler slot: " + i2);
                                SocketServer.t[i2] = new HandlerThread(this.clientSocket, t, i2);
                                SocketServer.t[i2].start();
                                bProcessed = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                    if (!bProcessed) {
                        Utils2.err("Server is too buzy.. ");
                        try {
                            this.clientSocket.close();
                        }
                        catch (Exception i2) {
                            // empty catch block
                        }
                        Utils2.err("The newly recieved connection is closed! ");
                    }
                    if (nextTimeToPrintReport >= System.currentTimeMillis()) continue;
                    nextTimeToPrintReport = System.currentTimeMillis() + 300000L;
                    System.out.println(HandlerThread.getReport());
                    System.out.println(SocketServer.getMemoryStatisics());
                }
                catch (IOException e) {
                    this.ex("connection received", e);
                    System.out.println(e);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException i2) {
                        // empty catch block
                    }
                }
            }
        }
        super.run();
        System.out.println("quitting server!");
        int i = 0;
        while (i < 1500) {
            if (t[i] != null) {
                this.log("Force closing handler slot: " + i + ", " + SocketServer.getMemoryStatisics());
                temp = t[i];
                SocketServer.t[i] = null;
                if (temp != null) {
                    temp.end();
                }
            }
            ++i;
        }
        System.out.println("quitting server finished!");
    }

    private void ex(String string, IOException e) {
        Utils2.ex("Server on port " + this.nPort + ": " + string, e);
    }

    private void log(String string) {
        System.out.println("Server on port: " + this.nPort + ": " + string);
    }

    private static String getMemoryStatisics() {
        if (runtime == null) {
            return "";
        }
        String strOut = "";
        try {
            int mb = 0x100000;
            strOut = "CPU Usage: " + ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage() + ".  Used Memory:" + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb;
            strOut = String.valueOf(strOut) + ", Free Memory:" + runtime.freeMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", Total Memory:" + runtime.totalMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", Max Memory:" + runtime.maxMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", Errors: " + Utils.nExecptions;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strOut;
    }

    public static int getCountOfOccupiedSlots() {
        int nOccupiedCount = 0;
        int i = 0;
        while (i < 1500) {
            if (t[i] != null && !t[i].IsHanged()) {
                ++nOccupiedCount;
            }
            ++i;
        }
        return nOccupiedCount;
    }

    public static String getMemoryStatisicsABR() {
        if (runtime == null) {
            return "";
        }
        String strOut = "";
        try {
            int mb = 0x100000;
            strOut = String.valueOf(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage()) + ", " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb;
            strOut = String.valueOf(strOut) + ", " + runtime.freeMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", " + runtime.totalMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", " + runtime.maxMemory() / (long)mb;
            strOut = String.valueOf(strOut) + ", " + Utils.nExecptions;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strOut;
    }
}

