/*
 * Decompiled with CFR 0.152.
 */
package com.mialerts.server;

import com.mialerts.server.Constants;
import com.mialerts.server.CustomPrintWriter;
import com.mialerts.server.CustomRequest;
import com.mialerts.server.DataStore;
import com.mialerts.server.Handler;
import com.mialerts.server.MiAlertsDevice;
import com.mialerts.server.SocketServer;
import com.mialerts.server.Utils;
import com.mialerts.server.Utils2;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class HandlerThread
extends Thread {
    String email;
    String password;
    String deviceID;
    long start_timestamp = Calendar.getInstance().getTime().getTime();
    Handler handlerObj = null;
    DataInputStream is = null;
    PrintStream os = null;
    Socket clientSocket = null;
    public HandlerThread[] t;
    int index = -1;
    static Timer timer = null;
    static ArrayList<String> urls = new ArrayList();
    URL site = null;
    BufferedReader site_in = null;
    int nFrames = 0;
    long timerStore = System.currentTimeMillis();
    static HashMap<Integer, Integer> processTime = new HashMap();
    static HashMap<Integer, Integer> processCount = new HashMap();

    public HandlerThread(Socket clientSocket, HandlerThread[] t, int index) {
        this.clientSocket = clientSocket;
        this.t = t;
        this.index = index;
        this.resetTimer();
    }

    void startWSCallsTimer() {
        this.log("startWSCallsTimer()");
        if (timer != null) {
            this.log("timer is already up");
            return;
        }
        timer = new Timer();
        timer.schedule((TimerTask)new URLCallTask(), 10000L);
    }

    void addToWSCallQueue(String url) {
        urls.add(url);
        this.log("WS added.. total queue: " + urls.size());
    }

    void actOnURLsQueue() {
        this.log("actOnURLsQueue");
        try {
            if (this.site_in != null) {
                this.site_in.close();
            }
            this.site_in = null;
        }
        catch (Exception exception) {}
        while (urls.size() > 0) {
            this.log("URLS queue left: " + urls.size());
            String str = urls.get(urls.size() - 1);
            urls.remove(urls.size() - 1);
            try {
                this.callWS(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void callWS(String url) {
        this.log("Calling WS: " + url);
        try {
            String inputLine;
            this.site = new URL(url);
            this.site_in = new BufferedReader(new InputStreamReader(this.site.openStream()));
            while ((inputLine = this.site_in.readLine()) != null) {
                this.log("Read: " + inputLine);
            }
            this.site_in.close();
            this.site_in = null;
            this.log("End Calling WS: " + url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        int nDroppedBytes = 0;
        String name = " Test User#" + this.index;
        if (this.clientSocket == null) {
            this.log("Null socket connection!");
            return;
        }
        try {
            this.log("Creating commands handler and connecting to DB!");
            this.handlerObj = new Handler();
            this.handlerObj.handlerLogName = "Thread#" + name;
            this.log("Command handler created!");
            if (!this.handlerObj.dataObj.isConnected() && !Utils.bMemoryOnlyOK) {
                this.log("Cannt connect to database! ending..");
                this.end();
                return;
            }
            try {
                this.log("creating listers..");
                if (this.clientSocket == null) {
                    this.log("no valid socket client anymore! ending..");
                    this.end();
                    return;
                }
                InputStream inputStream = this.clientSocket.getInputStream();
                if (inputStream == null) {
                    this.log("Cannt fetch the input stream! ending..");
                    this.end();
                    return;
                }
                this.is = new DataInputStream(inputStream);
                this.log("creating sender..");
                if (this.clientSocket == null) {
                    this.log("no valid socket client anymore! ending..");
                    this.end();
                    return;
                }
                byte[] baInput = new byte[200000];
                OutputStream outputStream = this.clientSocket.getOutputStream();
                if (outputStream == null) {
                    this.log("Cannt fetch the output stream! ending..");
                    this.end();
                    return;
                }
                this.log("sender created!");
                int nErrors = 0;
                if (this.is != null) {
                    this.startWSCallsTimer();
                }
                boolean bFirstTime = true;
                while (this.is != null) {
                    if (this.clientSocket == null || this.is == null) {
                        this.log("Socket is closed1");
                        break;
                    }
                    if (this.clientSocket == null || this.clientSocket.isClosed() || !this.clientSocket.isConnected()) {
                        this.log("Socket is closed");
                        break;
                    }
                    long signiture = 0L;
                    if (this.is != null) {
                        signiture = this.is.readLong();
                    }
                    if (signiture != 1234123456L) {
                        nDroppedBytes += 8;
                        this.log(this.os, "Unknown signuture sequance: " + signiture);
                        break;
                    }
                    int streamLength = 0;
                    if (this.is != null) {
                        streamLength = this.is.readInt();
                    }
                    if (streamLength < 200 || streamLength > 200000) {
                        nDroppedBytes += 4;
                        this.log(this.os, "Unknown characters sequance...");
                        break;
                    }
                    int nReadSize = 0;
                    try {
                        if (this.is != null) {
                            this.is.readFully(baInput, 0, streamLength);
                        }
                        nReadSize = streamLength;
                    }
                    catch (Exception e) {
                        this.ex(null, "Read full buffer", e);
                    }
                    if (nReadSize <= 0) {
                        this.Sleep(100);
                        this.log(this.os, "Reading zero length buffer!");
                    } else if (nReadSize == 200000) {
                        this.log(this.os, "Incomplet command of size: " + nReadSize);
                        nDroppedBytes += nReadSize;
                    } else if (nReadSize < 200) {
                        this.log(this.os, "Incomplet buffer... size: " + nReadSize);
                        nDroppedBytes += nReadSize;
                    } else {
                        String line;
                        if (nReadSize == streamLength) {
                            this.log(this.os, "Correct buffer... of size: " + nReadSize);
                        }
                        if ((line = new String(baInput, 0, Math.min(200, nReadSize))) == null) {
                            nDroppedBytes += nReadSize;
                            if (++nErrors <= Utils2.maxErrors) {
                                this.Sleep(500);
                                continue;
                            }
                        } else {
                            line = line.trim();
                            this.log(this.os, "command received: " + line);
                            if (line != null && line.startsWith("/quit")) {
                                this.log(this.os, "Exit command recieved!");
                            } else {
                                if (!line.startsWith("/")) {
                                    this.log("Invalid command... cmd: " + line);
                                    nDroppedBytes += nReadSize;
                                    this.log(this.os, "Exit command recieved!");
                                    continue;
                                }
                                long starttime = System.currentTimeMillis();
                                String output = this.process(line, baInput, nReadSize, outputStream);
                                long time = System.currentTimeMillis() - starttime;
                                if (Constants.nDebugSocketDelay > 0L) {
                                    while (time < Constants.nDebugSocketDelay) {
                                        HandlerThread.sleep(100L);
                                        time = System.currentTimeMillis() - starttime;
                                    }
                                }
                                this.log("Check4!");
                                HandlerThread.addReport((int)time);
                                long nWriteStart = System.currentTimeMillis();
                                if (line.contains("get4Jpegs") || line.contains("stream4Jpegs")) {
                                    this.log("Check5!");
                                } else {
                                    if (this.os == null) {
                                        this.os = new PrintStream(outputStream);
                                    }
                                    if (this.os != null) {
                                        this.os.println(output);
                                    }
                                }
                                long nWriteDelay = System.currentTimeMillis() - nWriteStart;
                                this.log("Writing time: " + nWriteDelay + "ms, process time: " + time + "ms, ocupied: " + HandlerThread.getCountOfOccupiedSlots() + ", Frames Received: " + this.nFrames);
                                String url = "http://mialerts.info/started_streaming_video.php?deviceid=" + this.deviceID;
                                if (bFirstTime && !line.contains("get4Jpegs") && !line.contains("getstream4Jpegs")) {
                                    this.addToWSCallQueue(url);
                                }
                                bFirstTime = false;
                                if (!line.contains("getstream4Jpegs")) continue;
                                this.log("Check point 9!");
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.log("Connection dropped or processing error!");
                this.ex(null, "MainReadingLoop", e);
                e.printStackTrace();
            }
            this.log("ByeBye..");
            this.end();
        }
        catch (Exception e) {
            this.ex(null, "ServerEx", e);
        }
    }

    private void log(PrintStream os2, String string) {
        this.log(string);
        if (os2 != null) {
            os2.print(string);
        }
    }

    private void Sleep(int time_ms) {
        try {
            HandlerThread.sleep(time_ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ex(DataStore dataObj, String loc, Exception e) {
        Utils.log(dataObj, "handler#" + this.index + ": " + "EX: " + loc + ": " + e.getMessage());
    }

    void notifyStreamingWatching(String line) {
        if (line.contains("get4Jpegs") || line.contains("getstream4Jpegs")) {
            String cams = "4";
            if (line.contains("getstream4Jpegs")) {
                cams = "9";
            }
            String url = "http://mialerts.info/extend_streaming_video.php?cams=" + cams + "&deviceid=" + this.deviceID;
            this.log("Refreshing streeming.. calling: " + url);
            this.addToWSCallQueue(url);
        }
    }

    private String process(String line, byte[] baInput, int nReadSize, OutputStream os) {
        this.dbg("processing..");
        CustomPrintWriter out = new CustomPrintWriter();
        Calendar cal = Calendar.getInstance();
        if (line == null || line.length() < 1) {
            return "";
        }
        if (line.contains("#TRK#")) {
            return "OK\r\n";
        }
        String cmd = this.getCmd(line);
        this.dbg("CMD: " + cmd);
        CustomRequest request = new CustomRequest(line);
        this.deviceID = request.getParameter("deviceid");
        MiAlertsDevice device = this.getDevice(this.deviceID);
        if (this.email == null || this.email.isEmpty()) {
            this.email = request.getParameter("user");
            this.password = request.getParameter("pwd");
        }
        if (cmd.equals("getstream4Jpegs")) {
            DataOutputStream dataOutStream;
            block35: {
                dataOutStream = new DataOutputStream(os);
                if (dataOutStream != null) break block35;
                this.log("could not create output channel!");
                return "could not create output channel!";
            }
            try {
                int MaxRespones = 10000;
                int t = 0;
                while (t < MaxRespones) {
                    this.log("Sending.. response#" + t + " for the command: " + cmd);
                    int nTrails = 0;
                    while (nTrails++ < 4 && !device.updateSnapshots()) {
                        this.log("All Same Images.. delaying for .5 sec");
                        this.Sleep(500);
                    }
                    this.log("check point 1");
                    int nTotalSizeOfCommandBuffer = 200;
                    boolean[] bNewImage = new boolean[4];
                    int idx = 0;
                    while (idx < 4) {
                        bNewImage[idx] = device.isCameraImageNew(idx);
                        int n = device.getCameraImageSize(idx);
                        if (n > 0 && bNewImage[idx]) {
                            ++this.nFrames;
                            nTotalSizeOfCommandBuffer += n;
                        } else {
                            this.log("Same Images: " + idx);
                        }
                        ++idx;
                    }
                    this.log("check point 2");
                    int address = 200;
                    byte[] command = new byte[nTotalSizeOfCommandBuffer];
                    String cmdText = "/rec4Jpegs?deviceid=" + this.deviceID + "&l0=" + device.getCameraImageSize(0) + "&l1=" + device.getCameraImageSize(1) + "&l2=" + device.getCameraImageSize(2) + "&l3=" + device.getCameraImageSize(3) + "&idx=" + t;
                    if (cmd.equals("getstream4Jpegs")) {
                        cmdText = "/recstream4Jpegs?deviceid=" + this.deviceID + "&l0=" + (bNewImage[0] ? device.getCameraImageSize(0) : 0) + "&l1=" + (bNewImage[1] ? device.getCameraImageSize(1) : 0) + "&l2=" + (bNewImage[2] ? device.getCameraImageSize(2) : 0) + "&l3=" + (bNewImage[3] ? device.getCameraImageSize(3) : 0) + "&idx=" + t;
                    }
                    this.log("check point 3");
                    if (t == MaxRespones - 1) {
                        cmdText = "/quit";
                    }
                    byte[] cmdBytes = cmdText.getBytes();
                    int i = 0;
                    while (i < cmdBytes.length) {
                        command[i] = cmdBytes[i];
                        ++i;
                    }
                    i = cmdBytes.length;
                    while (i < 200) {
                        command[i] = 0;
                        ++i;
                    }
                    this.log("check point 4");
                    int idx2 = 0;
                    while (idx2 < 4) {
                        if (bNewImage[idx2]) {
                            int i2 = 0;
                            while (i2 < device.getCameraImageSize(idx2)) {
                                command[address++] = device.cameras[idx2].imageBuffer[i2];
                                ++i2;
                            }
                        }
                        ++idx2;
                    }
                    this.log(" Size of command: " + command.length + ", Text part size: " + cmdBytes.length + ", total buffer size: " + nTotalSizeOfCommandBuffer + ", command# " + t + ": " + cmdText);
                    this.log("writing sig");
                    if (dataOutStream != null) {
                        dataOutStream.writeLong(1234123456L);
                    }
                    this.log("writing size");
                    if (dataOutStream != null) {
                        dataOutStream.writeInt(nTotalSizeOfCommandBuffer);
                    }
                    this.log("writing cmd");
                    if (dataOutStream != null) {
                        dataOutStream.write(command);
                    }
                    this.log("done writing");
                    if (t % 50 == 0) {
                        this.notifyStreamingWatching(line);
                    }
                    idx2 = 0;
                    while (idx2 < 4) {
                        if (bNewImage[idx2]) {
                            device.setCameraImageUsed(idx2);
                        }
                        ++idx2;
                    }
                    this.Sleep(100);
                    ++t;
                }
            }
            catch (Exception e) {
                System.err.println("Could not write to or read for device: " + this.deviceID + ", Successful frames: " + this.nFrames);
                this.ex(null, "ReadWrite", e);
            }
            this.log("Session disconnected for device: " + this.deviceID + ", Successful frames: " + this.nFrames);
        } else if (cmd.equals("set4Jpegs") || cmd.equals("stream4Jpegs")) {
            int[] nImagesLengths = new int[]{request.getIntParameter("l0"), request.getIntParameter("l1"), request.getIntParameter("l2"), request.getIntParameter("l3")};
            int nStart = 200;
            int t = 0;
            while (t < 4) {
                if (nImagesLengths[t] != 0) {
                    ++this.nFrames;
                    byte[] imageBuffer = new byte[nImagesLengths[t]];
                    if (baInput.length < nImagesLengths[t] + nStart) {
                        this.log("Invalid data buffer size: " + baInput.length + ", " + nImagesLengths[t] + nStart);
                        break;
                    }
                    int i = 0;
                    while (i < nImagesLengths[t]) {
                        imageBuffer[i] = baInput[i + nStart];
                        ++i;
                    }
                    nStart += nImagesLengths[t];
                    device.setCameraImage(t, imageBuffer);
                }
                ++t;
            }
            if (cmd.equals("set4Jpegs")) {
                out.println("<result>success<processed>" + nStart + "</processed></result>");
            }
            device.saveQuadImage();
        } else if (cmd.equals("ping")) {
            out.println("<result>success<message>pong</message></result>");
        } else {
            out.println("<result>error<reason>unknwon command</reason></result>");
            this.log("Unknown Command: " + line);
        }
        String ret = out.out;
        long processtime = Calendar.getInstance().getTimeInMillis() - cal.getTimeInMillis();
        this.dbg("Return: (" + processtime + "ms)" + ret);
        return ret;
    }

    private MiAlertsDevice getDevice(String id) {
        MiAlertsDevice device = null;
        device = Handler.getDevice(id);
        if (device == null) {
            this.log("Creating new device record: " + id);
            device = new MiAlertsDevice(id);
            Handler.addDevice(device);
        }
        return device;
    }

    private void dbg(String string) {
        this.resetTimer();
        Utils.dbg("handler#" + this.index + ": " + string);
    }

    private void log(CustomRequest request) {
        this.resetTimer();
        Utils.log(this.handlerObj.dataObj, "handler#" + this.index + ": " + "Processing: " + request.getRequestURI());
    }

    private String getCmd(String line) {
        if (line.length() < 5) {
            return "";
        }
        if (line.charAt(0) == '/') {
            int nEndOfCmd = line.indexOf(63);
            if (nEndOfCmd < 1) {
                return "";
            }
            return line.substring(1, nEndOfCmd);
        }
        return "";
    }

    private void log(String string) {
        this.resetTimer();
        Utils.log("handler#" + this.index + ": " + string);
    }

    private void resetTimer() {
        this.timerStore = System.currentTimeMillis();
    }

    public void end() {
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
        this.dbg("Unintilizing..");
        DataInputStream temp = this.is;
        this.is = null;
        if (temp != null) {
            try {
                temp.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PrintStream temp2 = this.os;
        this.os = null;
        if (temp2 != null) {
            try {
                temp2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Socket temp3 = this.clientSocket;
        this.clientSocket = null;
        if (temp3 != null) {
            try {
                temp3.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < 1500) {
            if (this.t[i] == this) {
                this.t[i] = null;
            }
            ++i;
        }
        this.log("Done clearing " + this.index);
    }

    public boolean IsHanged() {
        return this.IsHanged(false);
    }

    public boolean IsHanged(boolean bLogDelay) {
        if (System.currentTimeMillis() < this.timerStore) {
            return false;
        }
        long delay = System.currentTimeMillis() - this.timerStore;
        if (delay > Utils.maxDelayinMS) {
            if (bLogDelay) {
                this.log("Delayed thread! " + delay);
            }
            return true;
        }
        return false;
    }

    public static int getCountOfOccupiedSlots() {
        int nOccupiedCount = 0;
        int i = 0;
        while (i < 1500) {
            if (SocketServer.t[i] != null && !SocketServer.t[i].IsHanged()) {
                ++nOccupiedCount;
            }
            ++i;
        }
        return nOccupiedCount;
    }

    public static void addReport(int nProcessTime) {
        int nKey = SocketServer.getCountOfOccupiedSlots();
        if (!processTime.containsKey(nKey)) {
            processTime.put(nKey, 0);
            processCount.put(nKey, 0);
        }
        Integer usage = processTime.get(nKey);
        Integer nCount = processCount.get(nKey);
        usage = usage + nProcessTime;
        nCount = nCount + 1;
        processTime.put(nKey, usage);
        processCount.put(nKey, nCount);
    }

    public static String getReport() {
        String report = "Processing time report:\r\n";
        for (Map.Entry<Integer, Integer> pairs : processTime.entrySet()) {
            int nCallCount = processCount.get(pairs.getKey());
            if (nCallCount < 1) continue;
            report = String.valueOf(report) + pairs.getKey() + ", " + pairs.getValue() / nCallCount + "," + nCallCount + "\r\n";
        }
        return report;
    }

    class URLCallTask
    extends TimerTask {
        URLCallTask() {
        }

        @Override
        public void run() {
            HandlerThread.this.log("WS Time's up!");
            try {
                if (timer != null) {
                    timer.cancel();
                }
                timer = null;
            }
            catch (Exception e) {
                HandlerThread.this.ex(null, "Timer rescheduled3", e);
            }
            try {
                HandlerThread.this.actOnURLsQueue();
            }
            catch (Exception e) {
                HandlerThread.this.ex(null, "Timer rescheduled2", e);
            }
            try {
                HandlerThread.this.log("WS Time's up: rescheduling!");
                try {
                    if (timer != null) {
                        timer.cancel();
                    }
                    timer = null;
                }
                catch (Exception e) {
                    HandlerThread.this.ex(null, "Timer rescheduled4", e);
                }
                if (timer == null) {
                    timer = new Timer();
                }
                timer.schedule((TimerTask)new URLCallTask(), 10000L);
                HandlerThread.this.log("Timer rescheduled!");
            }
            catch (Exception e) {
                HandlerThread.this.ex(null, "Timer rescheduled", e);
            }
        }
    }
}

