<?php
require_once '../auth_controller.php';
class DevicesController extends AuthController {

	var $name = 'Devices';

	function index() {
		$this->Device->recursive = 0;
		$this->set('devices', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->flash(__('Invalid device', true), array('action' => 'index'));
		}
		$this->set('device', $this->Device->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->Device->create();
			if ($this->Device->save($this->data)) {
				$this->flash(__('Device saved.', true), array('action' => 'index'));
			} else {
			}
		}
		$members = $this->Device->Member->find('list');
		$this->set(compact('members'));
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->flash(sprintf(__('Invalid device', true)), array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Device->save($this->data)) {
				$this->flash(__('The device has been saved.', true), array('action' => 'index'));
			} else {
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Device->read(null, $id);
		}
		$members = $this->Device->Member->find('list');
		$this->set(compact('members'));
	}

	function delete($id = null) {
		if (!$id) {
			$this->flash(sprintf(__('Invalid device', true)), array('action' => 'index'));
		}
		if ($this->Device->delete($id)) {
			$this->flash(__('Device deleted', true), array('action' => 'index'));
		}
		$this->flash(__('Device was not deleted', true), array('action' => 'index'));
		$this->redirect(array('action' => 'index'));
	}
}
?>