<?php
require_once '../auth_controller.php';
class AlertTypesController extends AuthController {

	var $name = 'AlertTypes';

	function index() {
		$this->AlertType->recursive = 0;
		$this->set('alertTypes', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->flash(__('Invalid alert type', true), array('action' => 'index'));
		}
		$this->set('alertType', $this->AlertType->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->AlertType->create();
			if ($this->AlertType->save($this->data)) {
				$this->flash(__('Alerttype saved.', true), array('action' => 'index'));
			} else {
			}
		}
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->flash(sprintf(__('Invalid alert type', true)), array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->AlertType->save($this->data)) {
				$this->flash(__('The alert type has been saved.', true), array('action' => 'index'));
			} else {
			}
		}
		if (empty($this->data)) {
			$this->data = $this->AlertType->read(null, $id);
		}
	}

	function delete($id = null) {
		if (!$id) {
			$this->flash(sprintf(__('Invalid alert type', true)), array('action' => 'index'));
		}
		if ($this->AlertType->delete($id)) {
			$this->flash(__('Alert type deleted', true), array('action' => 'index'));
		}
		$this->flash(__('Alert type was not deleted', true), array('action' => 'index'));
		$this->redirect(array('action' => 'index'));
	}
}
?>