<?php
require_once '../auth_controller.php';
class MemberAlertsController extends AuthController {

	var $name = 'MemberAlerts';

	function index() {
		$this->MemberAlert->recursive = 0;
		$this->set('member_alerts', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->flash(__('Invalid Member alert', true), array('action' => 'index'));
		}
		$this->set('Member_alert', $this->MemberAlert->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->MemberAlert->create();
			if ($this->MemberAlert->save($this->data)) {
				$this->flash(__('Member alert saved.', true), array('action' => 'index'));
			} else {
			}
		}
		$members = $this->MemberAlert->Member->find('list');
		$this->set(compact('members'));
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->flash(sprintf(__('Invalid member alert', true)), array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->MemberAlert->save($this->data)) {
				$this->flash(__('The member alert has been saved.', true), array('action' => 'index'));
			} else {
			}
		}
		if (empty($this->data)) {
			$this->data = $this->MemberAlert->read(null, $id);
		}
//		$members = $this->MemberAlert->Member->find('list');

		//$members = $this->MemberAlert->Member->find('list');
		$this->set(compact('members'));
	}

	function delete($id = null) {
		if (!$id) {
			$this->flash(sprintf(__('Invalid member alert', true)), array('action' => 'index'));
		}
		if ($this->MemberAlert->delete($id)) {
			$this->flash(__('Member alert deleted', true), array('action' => 'index'));
		}
		$this->flash(__('Member alert was not deleted', true), array('action' => 'index'));
		$this->redirect(array('action' => 'index'));
	}
}
?>