<?php
require_once '../auth_controller.php';
class AlertsController extends AuthController {

	var $name = 'Alerts';

	function index() {
		$this->Alert->recursive = 0;
		$this->set('alerts', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->flash(__('Invalid alert', true), array('action' => 'index'));
		}
		$this->set('alert', $this->Alert->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->Alert->create();
			if ($this->Alert->save($this->data)) {
				$this->flash(__('Alert saved.', true), array('action' => 'index'));
			} else {
			}
		}
		$members = $this->Alert->Member->find('list');
		$alertTypes = $this->Alert->AlertType->find('list');
		$devices = $this->Alert->Device->find('list');
		$this->set(compact('members', 'alertTypes', 'devices'));
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->flash(sprintf(__('Invalid alert', true)), array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Alert->save($this->data)) {
				$this->flash(__('The alert has been saved.', true), array('action' => 'index'));
			} else {
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Alert->read(null, $id);
		}
		$members = $this->Alert->Member->find('list');
		$alertTypes = $this->Alert->AlertType->find('list');
		$devices = $this->Alert->Device->find('list');
		$this->set(compact('members', 'alertTypes', 'devices'));
	}

	function delete($id = null) {
		if (!$id) {
			$this->flash(sprintf(__('Invalid alert', true)), array('action' => 'index'));
		}
		if ($this->Alert->delete($id)) {
			$this->flash(__('Alert deleted', true), array('action' => 'index'));
		}
		$this->flash(__('Alert was not deleted', true), array('action' => 'index'));
		$this->redirect(array('action' => 'index'));
	}
}
?>