<?php
require_once '../auth_controller.php';
class CallsController extends AuthController {

	var $name = 'Calls';

	function index() {
		$this->Call->recursive = 0;
		$this->set('calls', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->flash(__('Invalid call', true), array('action' => 'index'));
		}
		$this->set('call', $this->Call->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->Call->create();
			if ($this->Call->save($this->data)) {
				$this->flash(__('Call saved.', true), array('action' => 'index'));
			} else {
			}
		}
		$devices = $this->Call->Device->find('list');
		$this->set(compact('devices'));
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->flash(sprintf(__('Invalid call', true)), array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Call->save($this->data)) {
				$this->flash(__('The call has been saved.', true), array('action' => 'index'));
			} else {
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Call->read(null, $id);
		}
		$devices = $this->Call->Device->find('list');
		$this->set(compact('devices'));
	}

	function delete($id = null) {
		if (!$id) {
			$this->flash(sprintf(__('Invalid call', true)), array('action' => 'index'));
		}
		if ($this->Call->delete($id)) {
			$this->flash(__('Call deleted', true), array('action' => 'index'));
		}
		$this->flash(__('Call was not deleted', true), array('action' => 'index'));
		$this->redirect(array('action' => 'index'));
	}
}
?>