//
//  VideoPlayViewController.m
//  iDing
//
//  Created by MacBook Pro on 23/09/13.
//  Copyright (c) 2013 mahammad. All rights reserved.
//

#import "VideoPlayViewController.h"

@interface VideoPlayViewController ()

@end

@implementation VideoPlayViewController
@synthesize vda,mutableData,urlConnection,mp4UrlLink,smallMP4UrlLink;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.title = self.vda.videoName;
    [self getMovieMP4URL];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7)
    {
        self.edgesForExtendedLayout = UIRectEdgeNone;
    }
    

    //[self loadvideoURL];
}

-(void)getMovieMP4URL
{
    MPMoviePlayerViewController *player = [[MPMoviePlayerViewController alloc]initWithContentURL:[NSURL URLWithString:self.vda.videoUrl]];
    [self presentMoviePlayerViewControllerAnimated:player];
    [player.moviePlayer play];
    return;
    
    
    
    HUD = [[MBProgressHUD alloc]initWithView:self.view];
    HUD.delegate = self;
    HUD.mode = MBProgressHUDModeIndeterminate;
    HUD.labelText = @"Loading...";
    [self.navigationController.view.superview addSubview:HUD];
    [HUD show:YES];

    if(self.mutableData!=nil)
    {
        self.mutableData=nil;
    }
    self.mutableData = [NSMutableData data];
    //http://mocal.mobi/listAlerts.php?username=whiletrue@hotmail.com&password=123
    //NSString *deviceId = [[UIDevice currentDevice]uniqueIdentifier];
    
    NSString *movieURl = [NSString stringWithFormat:@"http://mialerts.info/getVideoShort.php?url=%@",self.vda.videoUrl];
    NSURL *url = [NSURL URLWithString:movieURl];
    NSMutableURLRequest *urlRequest = [[[NSMutableURLRequest alloc]initWithURL:url]autorelease];
    if(self.urlConnection != nil)
    {
        [self.urlConnection release];
        self.urlConnection = nil;
    }
    
    [self.urlConnection setAccessibilityHint:@"GetMP4"];
    self.urlConnection = [[NSURLConnection alloc]initWithRequest:urlRequest delegate:self];
}


#pragma mark NSURLConnection Delegates
#pragma mark Connection callbacks

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
    //
	[self.mutableData setLength:0];
}
- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data
{
	[self.mutableData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
   // NSLog(@"error");
    UIAlertView *connAlert = [[UIAlertView alloc]initWithTitle:@"Error" message:[error description] delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
    [connAlert show];
    [connAlert release];
    
}
-(void)connectionDidFinishLoading:(NSURLConnection *)connection
{
    NSString *response = [[[NSString alloc]initWithData:self.mutableData encoding:NSASCIIStringEncoding] autorelease];
    //NSLog(@"the response is %@",response);
    [self parseVideosResponse:response];
}

-(void)parseVideosResponse:(NSString *)response
{
    
   // NSLog(@"the response is %@",response);
    if([response rangeOfString:@"success"].location != NSNotFound)
    {
        
        XMLParser* xml = [[XMLParser alloc] init];
        NSMutableDictionary* parsedDict = [xml parseXML:response mainElement:@"files"];
        [self parseDataWithDict:parsedDict];
        
    }
    else if([response rangeOfString:@"error"].location != NSNotFound)
    {
        UIAlertView *connAlert = [[UIAlertView alloc]initWithTitle:@"Error" message:@"something went wrong, Please try again later" delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [connAlert show];
        [connAlert release];
    }
    
    [HUD hide:YES];
    [HUD removeFromSuperview];
    HUD = nil;
}

-(void)parseDataWithDict:(NSMutableDictionary *)responseDict
{
    NSMutableArray *parsedvalues = [responseDict objectForKey:@"Values"];
    int g = [parsedvalues count];
    for (int k =0; k<g; k++) {
        
        NSDictionary *dict =[parsedvalues objectAtIndex:k];
        self.mp4UrlLink = [dict valueForKey:@"mp4"];
        self.smallMP4UrlLink = [dict valueForKey:@"small"];
    }
    // uodate
    
    [self loadvideoURL];
    
    if([UIApplication sharedApplication].isNetworkActivityIndicatorVisible == TRUE)
    {
        [[UIApplication sharedApplication]setNetworkActivityIndicatorVisible:FALSE];
    }
    
    [HUD hide:YES];
    [HUD removeFromSuperview];
    HUD = nil;
    
}


-(void)loadvideoURL
{
   // NSLog(@"the url is %@",self.mp4UrlLink);
  //  NSLog(@"the small url is %@",self.smallMP4UrlLink);
    
    //self.vda.videoUrl = [self.vda.videoUrl stringByReplacingOccurrencesOfString:@"h264" withString:@"mp4"];
    //[self.videoPlayerView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.mp4UrlLink]]];
    
    //[[UIApplication sharedApplication]openURL:[NSURL URLWithString:self.vda.videoUrl]];
    
    MPMoviePlayerViewController *player = [[MPMoviePlayerViewController alloc]initWithContentURL:[NSURL URLWithString:self.mp4UrlLink]];
    [self presentMoviePlayerViewControllerAnimated:player];
    [player.moviePlayer play];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    [_videoPlayerView release];
    [super dealloc];
}
- (void)viewDidUnload {
    [self setVideoPlayerView:nil];
    [super viewDidUnload];
}
@end
