//
//  DevicesPickerViewController.h
//  MiAlerts
//
//  Created by Mahammad on 12/10/14.
//  Copyright (c) 2014 Mahammad. All rights reserved.
//

#import <UIKit/UIKit.h>

@protocol DevicesPickerDelegate <NSObject>

-(void)touchedPicker:(NSString *)string;

@optional
-(void)setInitialPickerValueToRow:(int)i inComponent:(int)j animated:(BOOL)k;

@end

@interface DevicesPickerViewController : UIViewController <UIPickerViewDataSource, UIPickerViewDelegate>{
    UIPickerView *pickerView;
}

@property (nonatomic, strong) NSArray *contentArray;
@property (nonatomic, assign) id<DevicesPickerDelegate> delegatePicker;

- (id)initWithArray:(NSArray *)contents inFrame:(CGRect)pickerFrame;
@end
