/*
 * Decompiled with CFR 0.152.
 */
package com.mialerts.server;

import com.mialerts.server.Constants;
import com.mialerts.server.CustomRequest;
import com.mialerts.server.DataStore;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    public static final int validity = 120;
    public static final int max_distance = 30000;
    public static final int maxresults = 400;
    public static int gameNameLength = 3;
    public static int maxGameLife = 1440;
    public static String SystemUserID = "System";
    public static String SystemDeviceID = "SystemDevice";
    public static int gameDeletePeriod = 10080;
    public static long maxDelayinMS = 120000L;
    public static int nExecptions = 0;
    static SimpleDateFormat sdf = null;
    static SimpleDateFormat sdfLine = null;
    static String lastLogFilename = "";
    static BufferedOutputStream out = null;
    static FileOutputStream fos;
    public static boolean bMemoryOnlyOK;

    static {
        bMemoryOnlyOK = true;
    }

    public static void dbg(DataStore dataObj, String msg) {
        Utils.dbg(msg);
        Utils.addToLogDB(dataObj, msg);
    }

    public static void dbg(String msg) {
        if (!Constants.verbos) {
            return;
        }
        System.out.println(msg);
        Utils.filelog(msg);
    }

    private static void addToLogDB(DataStore dataObj, String msg) {
        if (!Constants.bLogToDB || dataObj == null) {
            return;
        }
        if (msg == null || msg.length() < 1) {
            return;
        }
        if (msg.length() > 240) {
            msg = msg.substring(1, 240);
        }
        msg = msg.replace('\'', '-');
        msg = msg.replace('\"', '-');
        if (dataObj != null) {
            dataObj.log(msg);
        }
    }

    public static void ex(DataStore dataObj, String msg) {
        System.out.println("EX: " + msg);
        Utils.filelog("EX: " + msg);
    }

    public static String getDateString(long timestamp) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("d/M/yyyy HH:mm");
            Date date = new Date(timestamp);
            return sdf.format(date);
        }
        catch (Exception exception) {
            return "1/1/2011 00:00";
        }
    }

    public static void ex(DataStore dataObj, String loction, Exception e) {
        Utils.ex(dataObj, String.valueOf(loction) + ": " + e.getMessage());
    }

    public static void log(DataStore dataObj, String msg) {
        Utils.log(msg);
        Utils.addToLogDB(dataObj, msg);
    }

    public static void log(String msg) {
        if (!Constants.debug) {
            return;
        }
        System.out.println(msg);
        Utils.filelog(msg);
    }

    public static void logTime(DataStore dataObj, String location, long timestamp) {
    }

    public static void log(DataStore dataObj, CustomRequest request) {
        Utils.log(dataObj, "Processing: " + request.getRequestURI());
    }

    public static double getDValue(String sDValue) {
        if (sDValue == null || sDValue.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(sDValue);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static int getIValue(String sIDValue) {
        if (sIDValue == null || sIDValue.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(sIDValue);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isSystemID(String playerid, String deviceid) {
        return SystemUserID.equalsIgnoreCase(playerid) || SystemDeviceID.equalsIgnoreCase(deviceid);
    }

    static String getLogsDir() {
        if (Utils.isWin()) {
            return "C://mialerts//";
        }
        return "/mialerts/";
    }

    static void filelog(String msg) {
        if (!Constants.bLogToFile) {
            return;
        }
        try {
            Date date;
            String filename;
            if (sdf == null) {
                System.out.println("Creating log dir");
                sdf = new SimpleDateFormat("yyMMDDHH");
                sdfLine = new SimpleDateFormat("mm:ss: ");
                String path = Utils.getLogsDir();
                File dir = new File(path);
                if (!dir.exists()) {
                    dir.mkdirs();
                } else {
                    System.out.println("log dir found before");
                }
            }
            boolean bHourChanged = !(filename = sdf.format(date = new Date())).equalsIgnoreCase(lastLogFilename);
            lastLogFilename = filename;
            if (bHourChanged) {
                System.out.println("exchange log file");
                String path = Utils.getLogsDir();
                filename = String.valueOf(path) + sdf.format(new Date()) + ".log";
                if (out != null) {
                    out.close();
                    fos.close();
                }
                out = null;
                File file = new File(filename);
                try {
                    fos = new FileOutputStream(file);
                    out = new BufferedOutputStream(fos);
                    System.out.println("loging to " + file.getAbsolutePath());
                }
                catch (Exception e) {
                    System.out.println("File Ex: " + e.getMessage());
                }
            }
            if (out != null) {
                out.write((String.valueOf(sdfLine.format(date)) + msg + "\r\n").getBytes());
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getBValue(String paramdebug) {
        try {
            String strDebug;
            if (paramdebug != null && ((strDebug = paramdebug).equalsIgnoreCase("1") || strDebug.equalsIgnoreCase("true"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWin() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }

    public static void dsp(String string) {
    }
}

