/*
 * Decompiled with CFR 0.152.
 */
package com.mialerts.server;

import com.mialerts.server.Utils;
import com.mialerts.server.Utils2;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import javax.imageio.ImageIO;

public class Snapshot {
    String filePath;
    long time;
    byte[] imageBuffer;
    public boolean bNewImage;

    Snapshot() {
        this.bNewImage = false;
        this.time = 0L;
        this.imageBuffer = null;
        this.filePath = "";
    }

    public Snapshot(String path) {
        this.time = 0L;
        this.imageBuffer = null;
        this.loadImageFromFile(path);
    }

    long age() {
        if (this.time == 0L) {
            return 0L;
        }
        return Calendar.getInstance().getTime().getTime() - this.time;
    }

    boolean isValid() {
        if (this.time == 0L) {
            return false;
        }
        if (this.age() > 1000000L) {
            return false;
        }
        if (this.imageBuffer == null) {
            return false;
        }
        return this.imageBuffer.length != 0;
    }

    public void updateImageFromFile() {
        this.loadImageFromFile(this.filePath);
    }

    private void loadImageFromFile(String path) {
        this.filePath = path;
        byte[] oldImageBuffer = this.imageBuffer;
        this.imageBuffer = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                return;
            }
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                Utils.dbg("image file not found: " + path);
                this.imageBuffer = null;
                this.bNewImage = false;
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", baos);
            baos.flush();
            byte[] imageBuffer2 = (byte[])baos.toByteArray().clone();
            baos.close();
            boolean bSameAlmost = false;
            if (oldImageBuffer != null && imageBuffer2 != null && oldImageBuffer.length == imageBuffer2.length) {
                bSameAlmost = true;
            }
            if (oldImageBuffer == null && imageBuffer2 == null) {
                bSameAlmost = true;
            }
            this.imageBuffer = imageBuffer2;
            this.bNewImage = bSameAlmost ? false : imageBuffer2 != null;
            this.time = Calendar.getInstance().getTime().getTime();
        }
        catch (Exception e) {
            Utils.ex(null, "Error load image from frile: " + path, e);
            e.printStackTrace();
        }
    }

    public void setImage(byte[] imageBuffer2) {
        this.imageBuffer = imageBuffer2;
        this.saveToDisk();
    }

    private boolean saveToDisk() {
        if (this.imageBuffer == null || this.imageBuffer.length < 10) {
            return false;
        }
        try {
            Path path = Paths.get(this.filePath, new String[0]);
            try {
                Files.deleteIfExists(path);
            }
            catch (NoSuchFileException x) {
                Utils2.ex(path + ": no such file or directory", x);
            }
            catch (DirectoryNotEmptyException x) {
                Utils2.ex(path + ":  not empty", x);
            }
            catch (IOException x) {
                Utils2.ex(path + ":  File permission problems", x);
            }
            Utils.log(null, "trying to write image to disk: " + this.filePath);
            RandomAccessFile f = new RandomAccessFile(this.filePath, "rw");
            f.write(this.imageBuffer);
            f.close();
            Utils.log("image wrote to disk: " + this.filePath);
        }
        catch (Exception e) {
            Utils.ex(null, "Error writing image to disk: " + this.filePath, e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public BufferedImage getImage() {
        if (this.imageBuffer == null || this.imageBuffer.length < 10) {
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.imageBuffer);
            BufferedImage bImageFromConvert = ImageIO.read(in);
            return bImageFromConvert;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

